package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteEnvironmentResponse(
    environment: Optional[zio.aws.proton.model.Environment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse = {
    import DeleteEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse
      .builder()
      .optionallyWith(environment.map(value => value.buildAwsValue()))(
        _.environment
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly =
    zio.aws.proton.model.DeleteEnvironmentResponse.wrap(buildAwsValue())
}
object DeleteEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteEnvironmentResponse =
      zio.aws.proton.model
        .DeleteEnvironmentResponse(environment.map(value => value.asEditable))
    def environment: Optional[zio.aws.proton.model.Environment.ReadOnly]
    def getEnvironment
        : ZIO[Any, AwsError, zio.aws.proton.model.Environment.ReadOnly] =
      AwsError.unwrapOptionField("environment", environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse
  ) extends zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly {
    override val environment
        : Optional[zio.aws.proton.model.Environment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.environment())
        .map(value => zio.aws.proton.model.Environment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteEnvironmentResponse
  ): zio.aws.proton.model.DeleteEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
