package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteServiceResponse(
    service: Optional[zio.aws.proton.model.Service] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteServiceResponse = {
    import DeleteServiceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteServiceResponse
      .builder()
      .optionallyWith(service.map(value => value.buildAwsValue()))(_.service)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.DeleteServiceResponse.ReadOnly =
    zio.aws.proton.model.DeleteServiceResponse.wrap(buildAwsValue())
}
object DeleteServiceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteServiceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteServiceResponse =
      zio.aws.proton.model
        .DeleteServiceResponse(service.map(value => value.asEditable))
    def service: Optional[zio.aws.proton.model.Service.ReadOnly]
    def getService: ZIO[Any, AwsError, zio.aws.proton.model.Service.ReadOnly] =
      AwsError.unwrapOptionField("service", service)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceResponse
  ) extends zio.aws.proton.model.DeleteServiceResponse.ReadOnly {
    override val service: Optional[zio.aws.proton.model.Service.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.service())
        .map(value => zio.aws.proton.model.Service.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceResponse
  ): zio.aws.proton.model.DeleteServiceResponse.ReadOnly = new Wrapper(impl)
}
