package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteServiceSyncConfigResponse(
    serviceSyncConfig: Optional[zio.aws.proton.model.ServiceSyncConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigResponse = {
    import DeleteServiceSyncConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigResponse
      .builder()
      .optionallyWith(serviceSyncConfig.map(value => value.buildAwsValue()))(
        _.serviceSyncConfig
      )
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.DeleteServiceSyncConfigResponse.ReadOnly =
    zio.aws.proton.model.DeleteServiceSyncConfigResponse.wrap(buildAwsValue())
}
object DeleteServiceSyncConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteServiceSyncConfigResponse =
      zio.aws.proton.model.DeleteServiceSyncConfigResponse(
        serviceSyncConfig.map(value => value.asEditable)
      )
    def serviceSyncConfig
        : Optional[zio.aws.proton.model.ServiceSyncConfig.ReadOnly]
    def getServiceSyncConfig
        : ZIO[Any, AwsError, zio.aws.proton.model.ServiceSyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("serviceSyncConfig", serviceSyncConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigResponse
  ) extends zio.aws.proton.model.DeleteServiceSyncConfigResponse.ReadOnly {
    override val serviceSyncConfig
        : Optional[zio.aws.proton.model.ServiceSyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceSyncConfig())
        .map(value => zio.aws.proton.model.ServiceSyncConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceSyncConfigResponse
  ): zio.aws.proton.model.DeleteServiceSyncConfigResponse.ReadOnly =
    new Wrapper(impl)
}
