package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteServiceTemplateVersionResponse(
    serviceTemplateVersion: Optional[
      zio.aws.proton.model.ServiceTemplateVersion
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionResponse = {
    import DeleteServiceTemplateVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionResponse
      .builder()
      .optionallyWith(
        serviceTemplateVersion.map(value => value.buildAwsValue())
      )(_.serviceTemplateVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.DeleteServiceTemplateVersionResponse.ReadOnly =
    zio.aws.proton.model.DeleteServiceTemplateVersionResponse
      .wrap(buildAwsValue())
}
object DeleteServiceTemplateVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.DeleteServiceTemplateVersionResponse =
      zio.aws.proton.model.DeleteServiceTemplateVersionResponse(
        serviceTemplateVersion.map(value => value.asEditable)
      )
    def serviceTemplateVersion
        : Optional[zio.aws.proton.model.ServiceTemplateVersion.ReadOnly]
    def getServiceTemplateVersion: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ServiceTemplateVersion.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceTemplateVersion",
      serviceTemplateVersion
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionResponse
  ) extends zio.aws.proton.model.DeleteServiceTemplateVersionResponse.ReadOnly {
    override val serviceTemplateVersion
        : Optional[zio.aws.proton.model.ServiceTemplateVersion.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceTemplateVersion())
        .map(value => zio.aws.proton.model.ServiceTemplateVersion.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.DeleteServiceTemplateVersionResponse
  ): zio.aws.proton.model.DeleteServiceTemplateVersionResponse.ReadOnly =
    new Wrapper(impl)
}
