package zio.aws.proton.model
import scala.jdk.CollectionConverters.*
sealed trait DeploymentStatus {
  def unwrap: software.amazon.awssdk.services.proton.model.DeploymentStatus
}
object DeploymentStatus {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.DeploymentStatus
  ): zio.aws.proton.model.DeploymentStatus = value match {
    case software.amazon.awssdk.services.proton.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.DeploymentStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.proton.model.DeploymentStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.proton.model.DeploymentStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.proton.model.DeploymentStatus.DELETE_IN_PROGRESS =>
      val r = DELETE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.proton.model.DeploymentStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
    case software.amazon.awssdk.services.proton.model.DeploymentStatus.DELETE_COMPLETE =>
      val r = DELETE_COMPLETE
      r
    case software.amazon.awssdk.services.proton.model.DeploymentStatus.CANCELLING =>
      val r = CANCELLING
      r
    case software.amazon.awssdk.services.proton.model.DeploymentStatus.CANCELLED =>
      val r = CANCELLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentStatus =
      software.amazon.awssdk.services.proton.model.DeploymentStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object IN_PROGRESS extends zio.aws.proton.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentStatus =
      software.amazon.awssdk.services.proton.model.DeploymentStatus.IN_PROGRESS
  }
  case object FAILED extends zio.aws.proton.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentStatus =
      software.amazon.awssdk.services.proton.model.DeploymentStatus.FAILED
  }
  case object SUCCEEDED extends zio.aws.proton.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentStatus =
      software.amazon.awssdk.services.proton.model.DeploymentStatus.SUCCEEDED
  }
  case object DELETE_IN_PROGRESS extends zio.aws.proton.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentStatus =
      software.amazon.awssdk.services.proton.model.DeploymentStatus.DELETE_IN_PROGRESS
  }
  case object DELETE_FAILED extends zio.aws.proton.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentStatus =
      software.amazon.awssdk.services.proton.model.DeploymentStatus.DELETE_FAILED
  }
  case object DELETE_COMPLETE extends zio.aws.proton.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentStatus =
      software.amazon.awssdk.services.proton.model.DeploymentStatus.DELETE_COMPLETE
  }
  case object CANCELLING extends zio.aws.proton.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentStatus =
      software.amazon.awssdk.services.proton.model.DeploymentStatus.CANCELLING
  }
  case object CANCELLED extends zio.aws.proton.model.DeploymentStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.DeploymentStatus =
      software.amazon.awssdk.services.proton.model.DeploymentStatus.CANCELLED
  }
}
