package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  Timestamp,
  Description,
  EnvironmentTemplateVersionArn,
  StatusMessage,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class EnvironmentTemplateVersionSummary(
    arn: EnvironmentTemplateVersionArn,
    createdAt: Timestamp,
    description: Optional[Description] = Optional.Absent,
    lastModifiedAt: Timestamp,
    majorVersion: TemplateVersionPart,
    minorVersion: TemplateVersionPart,
    recommendedMinorVersion: Optional[TemplateVersionPart] = Optional.Absent,
    status: zio.aws.proton.model.TemplateVersionStatus,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.EnvironmentTemplateVersionSummary = {
    import EnvironmentTemplateVersionSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.EnvironmentTemplateVersionSummary
      .builder()
      .arn(EnvironmentTemplateVersionArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .lastModifiedAt(Timestamp.unwrap(lastModifiedAt): Instant)
      .majorVersion(TemplateVersionPart.unwrap(majorVersion): java.lang.String)
      .minorVersion(TemplateVersionPart.unwrap(minorVersion): java.lang.String)
      .optionallyWith(
        recommendedMinorVersion.map(value =>
          TemplateVersionPart.unwrap(value): java.lang.String
        )
      )(_.recommendedMinorVersion)
      .status(status.unwrap)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly =
    zio.aws.proton.model.EnvironmentTemplateVersionSummary.wrap(buildAwsValue())
}
object EnvironmentTemplateVersionSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.EnvironmentTemplateVersionSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.EnvironmentTemplateVersionSummary =
      zio.aws.proton.model.EnvironmentTemplateVersionSummary(
        arn,
        createdAt,
        description.map(value => value),
        lastModifiedAt,
        majorVersion,
        minorVersion,
        recommendedMinorVersion.map(value => value),
        status,
        statusMessage.map(value => value),
        templateName
      )
    def arn: EnvironmentTemplateVersionArn
    def createdAt: Timestamp
    def description: Optional[Description]
    def lastModifiedAt: Timestamp
    def majorVersion: TemplateVersionPart
    def minorVersion: TemplateVersionPart
    def recommendedMinorVersion: Optional[TemplateVersionPart]
    def status: zio.aws.proton.model.TemplateVersionStatus
    def statusMessage: Optional[StatusMessage]
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, EnvironmentTemplateVersionArn] =
      ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastModifiedAt)
    def getMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(majorVersion)
    def getMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(minorVersion)
    def getRecommendedMinorVersion: ZIO[Any, AwsError, TemplateVersionPart] =
      AwsError.unwrapOptionField(
        "recommendedMinorVersion",
        recommendedMinorVersion
      )
    def getStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.TemplateVersionStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentTemplateVersionSummary
  ) extends zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly {
    override val arn: EnvironmentTemplateVersionArn =
      zio.aws.proton.model.primitives.EnvironmentTemplateVersionArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.proton.model.primitives.Description(value))
    override val lastModifiedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.lastModifiedAt())
    override val majorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.majorVersion())
    override val minorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.minorVersion())
    override val recommendedMinorVersion: Optional[TemplateVersionPart] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recommendedMinorVersion())
        .map(value =>
          zio.aws.proton.model.primitives.TemplateVersionPart(value)
        )
    override val status: zio.aws.proton.model.TemplateVersionStatus =
      zio.aws.proton.model.TemplateVersionStatus.wrap(impl.status())
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.EnvironmentTemplateVersionSummary
  ): zio.aws.proton.model.EnvironmentTemplateVersionSummary.ReadOnly =
    new Wrapper(impl)
}
