package zio.aws.proton.model
import zio.aws.proton.model.primitives.EnvironmentAccountConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEnvironmentAccountConnectionRequest(
    id: EnvironmentAccountConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionRequest = {
    import GetEnvironmentAccountConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionRequest
      .builder()
      .id(EnvironmentAccountConnectionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.GetEnvironmentAccountConnectionRequest.ReadOnly =
    zio.aws.proton.model.GetEnvironmentAccountConnectionRequest
      .wrap(buildAwsValue())
}
object GetEnvironmentAccountConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.GetEnvironmentAccountConnectionRequest =
      zio.aws.proton.model.GetEnvironmentAccountConnectionRequest(id)
    def id: EnvironmentAccountConnectionId
    def getId: ZIO[Any, Nothing, EnvironmentAccountConnectionId] =
      ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionRequest
  ) extends zio.aws.proton.model.GetEnvironmentAccountConnectionRequest.ReadOnly {
    override val id: EnvironmentAccountConnectionId =
      zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentAccountConnectionRequest
  ): zio.aws.proton.model.GetEnvironmentAccountConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
