package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEnvironmentResponse(
    environment: zio.aws.proton.model.Environment
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetEnvironmentResponse = {
    import GetEnvironmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetEnvironmentResponse
      .builder()
      .environment(environment.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetEnvironmentResponse.ReadOnly =
    zio.aws.proton.model.GetEnvironmentResponse.wrap(buildAwsValue())
}
object GetEnvironmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetEnvironmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetEnvironmentResponse =
      zio.aws.proton.model.GetEnvironmentResponse(environment.asEditable)
    def environment: zio.aws.proton.model.Environment.ReadOnly
    def getEnvironment
        : ZIO[Any, Nothing, zio.aws.proton.model.Environment.ReadOnly] =
      ZIO.succeed(environment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentResponse
  ) extends zio.aws.proton.model.GetEnvironmentResponse.ReadOnly {
    override val environment: zio.aws.proton.model.Environment.ReadOnly =
      zio.aws.proton.model.Environment.wrap(impl.environment())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentResponse
  ): zio.aws.proton.model.GetEnvironmentResponse.ReadOnly = new Wrapper(impl)
}
