package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, TemplateVersionPart}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetEnvironmentTemplateVersionRequest(
    majorVersion: TemplateVersionPart,
    minorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest = {
    import GetEnvironmentTemplateVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest
      .builder()
      .majorVersion(TemplateVersionPart.unwrap(majorVersion): java.lang.String)
      .minorVersion(TemplateVersionPart.unwrap(minorVersion): java.lang.String)
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.GetEnvironmentTemplateVersionRequest.ReadOnly =
    zio.aws.proton.model.GetEnvironmentTemplateVersionRequest
      .wrap(buildAwsValue())
}
object GetEnvironmentTemplateVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetEnvironmentTemplateVersionRequest =
      zio.aws.proton.model.GetEnvironmentTemplateVersionRequest(
        majorVersion,
        minorVersion,
        templateName
      )
    def majorVersion: TemplateVersionPart
    def minorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(majorVersion)
    def getMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(minorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest
  ) extends zio.aws.proton.model.GetEnvironmentTemplateVersionRequest.ReadOnly {
    override val majorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.majorVersion())
    override val minorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives.TemplateVersionPart(impl.minorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetEnvironmentTemplateVersionRequest
  ): zio.aws.proton.model.GetEnvironmentTemplateVersionRequest.ReadOnly =
    new Wrapper(impl)
}
