package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRepositoryResponse(
    repository: zio.aws.proton.model.Repository
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetRepositoryResponse = {
    import GetRepositoryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetRepositoryResponse
      .builder()
      .repository(repository.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetRepositoryResponse.ReadOnly =
    zio.aws.proton.model.GetRepositoryResponse.wrap(buildAwsValue())
}
object GetRepositoryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetRepositoryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetRepositoryResponse =
      zio.aws.proton.model.GetRepositoryResponse(repository.asEditable)
    def repository: zio.aws.proton.model.Repository.ReadOnly
    def getRepository
        : ZIO[Any, Nothing, zio.aws.proton.model.Repository.ReadOnly] =
      ZIO.succeed(repository)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetRepositoryResponse
  ) extends zio.aws.proton.model.GetRepositoryResponse.ReadOnly {
    override val repository: zio.aws.proton.model.Repository.ReadOnly =
      zio.aws.proton.model.Repository.wrap(impl.repository())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetRepositoryResponse
  ): zio.aws.proton.model.GetRepositoryResponse.ReadOnly = new Wrapper(impl)
}
