package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRepositorySyncStatusResponse(
    latestSync: Optional[zio.aws.proton.model.RepositorySyncAttempt] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusResponse = {
    import GetRepositorySyncStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusResponse
      .builder()
      .optionallyWith(latestSync.map(value => value.buildAwsValue()))(
        _.latestSync
      )
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.GetRepositorySyncStatusResponse.ReadOnly =
    zio.aws.proton.model.GetRepositorySyncStatusResponse.wrap(buildAwsValue())
}
object GetRepositorySyncStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetRepositorySyncStatusResponse =
      zio.aws.proton.model.GetRepositorySyncStatusResponse(
        latestSync.map(value => value.asEditable)
      )
    def latestSync
        : Optional[zio.aws.proton.model.RepositorySyncAttempt.ReadOnly]
    def getLatestSync: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.RepositorySyncAttempt.ReadOnly
    ] = AwsError.unwrapOptionField("latestSync", latestSync)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusResponse
  ) extends zio.aws.proton.model.GetRepositorySyncStatusResponse.ReadOnly {
    override val latestSync
        : Optional[zio.aws.proton.model.RepositorySyncAttempt.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestSync())
        .map(value => zio.aws.proton.model.RepositorySyncAttempt.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetRepositorySyncStatusResponse
  ): zio.aws.proton.model.GetRepositorySyncStatusResponse.ReadOnly =
    new Wrapper(impl)
}
