package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetServiceInstanceSyncStatusResponse(
    desiredState: Optional[zio.aws.proton.model.Revision] = Optional.Absent,
    latestSuccessfulSync: Optional[zio.aws.proton.model.ResourceSyncAttempt] =
      Optional.Absent,
    latestSync: Optional[zio.aws.proton.model.ResourceSyncAttempt] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceInstanceSyncStatusResponse = {
    import GetServiceInstanceSyncStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceInstanceSyncStatusResponse
      .builder()
      .optionallyWith(desiredState.map(value => value.buildAwsValue()))(
        _.desiredState
      )
      .optionallyWith(latestSuccessfulSync.map(value => value.buildAwsValue()))(
        _.latestSuccessfulSync
      )
      .optionallyWith(latestSync.map(value => value.buildAwsValue()))(
        _.latestSync
      )
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.GetServiceInstanceSyncStatusResponse.ReadOnly =
    zio.aws.proton.model.GetServiceInstanceSyncStatusResponse
      .wrap(buildAwsValue())
}
object GetServiceInstanceSyncStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceInstanceSyncStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceInstanceSyncStatusResponse =
      zio.aws.proton.model.GetServiceInstanceSyncStatusResponse(
        desiredState.map(value => value.asEditable),
        latestSuccessfulSync.map(value => value.asEditable),
        latestSync.map(value => value.asEditable)
      )
    def desiredState: Optional[zio.aws.proton.model.Revision.ReadOnly]
    def latestSuccessfulSync
        : Optional[zio.aws.proton.model.ResourceSyncAttempt.ReadOnly]
    def latestSync: Optional[zio.aws.proton.model.ResourceSyncAttempt.ReadOnly]
    def getDesiredState
        : ZIO[Any, AwsError, zio.aws.proton.model.Revision.ReadOnly] =
      AwsError.unwrapOptionField("desiredState", desiredState)
    def getLatestSuccessfulSync: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceSyncAttempt.ReadOnly
    ] = AwsError.unwrapOptionField("latestSuccessfulSync", latestSuccessfulSync)
    def getLatestSync: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ResourceSyncAttempt.ReadOnly
    ] = AwsError.unwrapOptionField("latestSync", latestSync)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceInstanceSyncStatusResponse
  ) extends zio.aws.proton.model.GetServiceInstanceSyncStatusResponse.ReadOnly {
    override val desiredState
        : Optional[zio.aws.proton.model.Revision.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.desiredState())
        .map(value => zio.aws.proton.model.Revision.wrap(value))
    override val latestSuccessfulSync
        : Optional[zio.aws.proton.model.ResourceSyncAttempt.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestSuccessfulSync())
        .map(value => zio.aws.proton.model.ResourceSyncAttempt.wrap(value))
    override val latestSync
        : Optional[zio.aws.proton.model.ResourceSyncAttempt.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestSync())
        .map(value => zio.aws.proton.model.ResourceSyncAttempt.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceInstanceSyncStatusResponse
  ): zio.aws.proton.model.GetServiceInstanceSyncStatusResponse.ReadOnly =
    new Wrapper(impl)
}
