package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetServiceSyncBlockerSummaryRequest(
    serviceInstanceName: Optional[ResourceName] = Optional.Absent,
    serviceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryRequest = {
    import GetServiceSyncBlockerSummaryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryRequest
      .builder()
      .optionallyWith(
        serviceInstanceName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.serviceInstanceName)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.GetServiceSyncBlockerSummaryRequest.ReadOnly =
    zio.aws.proton.model.GetServiceSyncBlockerSummaryRequest
      .wrap(buildAwsValue())
}
object GetServiceSyncBlockerSummaryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceSyncBlockerSummaryRequest =
      zio.aws.proton.model.GetServiceSyncBlockerSummaryRequest(
        serviceInstanceName.map(value => value),
        serviceName
      )
    def serviceInstanceName: Optional[ResourceName]
    def serviceName: ResourceName
    def getServiceInstanceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceInstanceName", serviceInstanceName)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryRequest
  ) extends zio.aws.proton.model.GetServiceSyncBlockerSummaryRequest.ReadOnly {
    override val serviceInstanceName: Optional[ResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceInstanceName())
        .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryRequest
  ): zio.aws.proton.model.GetServiceSyncBlockerSummaryRequest.ReadOnly =
    new Wrapper(impl)
}
