package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetServiceSyncBlockerSummaryResponse(
    serviceSyncBlockerSummary: Optional[
      zio.aws.proton.model.ServiceSyncBlockerSummary
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryResponse = {
    import GetServiceSyncBlockerSummaryResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryResponse
      .builder()
      .optionallyWith(
        serviceSyncBlockerSummary.map(value => value.buildAwsValue())
      )(_.serviceSyncBlockerSummary)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.GetServiceSyncBlockerSummaryResponse.ReadOnly =
    zio.aws.proton.model.GetServiceSyncBlockerSummaryResponse
      .wrap(buildAwsValue())
}
object GetServiceSyncBlockerSummaryResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceSyncBlockerSummaryResponse =
      zio.aws.proton.model.GetServiceSyncBlockerSummaryResponse(
        serviceSyncBlockerSummary.map(value => value.asEditable)
      )
    def serviceSyncBlockerSummary
        : Optional[zio.aws.proton.model.ServiceSyncBlockerSummary.ReadOnly]
    def getServiceSyncBlockerSummary: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ServiceSyncBlockerSummary.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceSyncBlockerSummary",
      serviceSyncBlockerSummary
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryResponse
  ) extends zio.aws.proton.model.GetServiceSyncBlockerSummaryResponse.ReadOnly {
    override val serviceSyncBlockerSummary
        : Optional[zio.aws.proton.model.ServiceSyncBlockerSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceSyncBlockerSummary())
        .map(value =>
          zio.aws.proton.model.ServiceSyncBlockerSummary.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceSyncBlockerSummaryResponse
  ): zio.aws.proton.model.GetServiceSyncBlockerSummaryResponse.ReadOnly =
    new Wrapper(impl)
}
