package zio.aws.proton.model
import zio.aws.proton.model.primitives.ResourceName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetServiceSyncConfigRequest(serviceName: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceSyncConfigRequest = {
    import GetServiceSyncConfigRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceSyncConfigRequest
      .builder()
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetServiceSyncConfigRequest.ReadOnly =
    zio.aws.proton.model.GetServiceSyncConfigRequest.wrap(buildAwsValue())
}
object GetServiceSyncConfigRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceSyncConfigRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceSyncConfigRequest =
      zio.aws.proton.model.GetServiceSyncConfigRequest(serviceName)
    def serviceName: ResourceName
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceSyncConfigRequest
  ) extends zio.aws.proton.model.GetServiceSyncConfigRequest.ReadOnly {
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceSyncConfigRequest
  ): zio.aws.proton.model.GetServiceSyncConfigRequest.ReadOnly = new Wrapper(
    impl
  )
}
