package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetServiceSyncConfigResponse(
    serviceSyncConfig: Optional[zio.aws.proton.model.ServiceSyncConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceSyncConfigResponse = {
    import GetServiceSyncConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceSyncConfigResponse
      .builder()
      .optionallyWith(serviceSyncConfig.map(value => value.buildAwsValue()))(
        _.serviceSyncConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetServiceSyncConfigResponse.ReadOnly =
    zio.aws.proton.model.GetServiceSyncConfigResponse.wrap(buildAwsValue())
}
object GetServiceSyncConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceSyncConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceSyncConfigResponse =
      zio.aws.proton.model.GetServiceSyncConfigResponse(
        serviceSyncConfig.map(value => value.asEditable)
      )
    def serviceSyncConfig
        : Optional[zio.aws.proton.model.ServiceSyncConfig.ReadOnly]
    def getServiceSyncConfig
        : ZIO[Any, AwsError, zio.aws.proton.model.ServiceSyncConfig.ReadOnly] =
      AwsError.unwrapOptionField("serviceSyncConfig", serviceSyncConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceSyncConfigResponse
  ) extends zio.aws.proton.model.GetServiceSyncConfigResponse.ReadOnly {
    override val serviceSyncConfig
        : Optional[zio.aws.proton.model.ServiceSyncConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceSyncConfig())
        .map(value => zio.aws.proton.model.ServiceSyncConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceSyncConfigResponse
  ): zio.aws.proton.model.GetServiceSyncConfigResponse.ReadOnly = new Wrapper(
    impl
  )
}
