package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetServiceTemplateResponse(
    serviceTemplate: zio.aws.proton.model.ServiceTemplate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.GetServiceTemplateResponse = {
    import GetServiceTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.GetServiceTemplateResponse
      .builder()
      .serviceTemplate(serviceTemplate.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.GetServiceTemplateResponse.ReadOnly =
    zio.aws.proton.model.GetServiceTemplateResponse.wrap(buildAwsValue())
}
object GetServiceTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.GetServiceTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.GetServiceTemplateResponse =
      zio.aws.proton.model
        .GetServiceTemplateResponse(serviceTemplate.asEditable)
    def serviceTemplate: zio.aws.proton.model.ServiceTemplate.ReadOnly
    def getServiceTemplate
        : ZIO[Any, Nothing, zio.aws.proton.model.ServiceTemplate.ReadOnly] =
      ZIO.succeed(serviceTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.GetServiceTemplateResponse
  ) extends zio.aws.proton.model.GetServiceTemplateResponse.ReadOnly {
    override val serviceTemplate
        : zio.aws.proton.model.ServiceTemplate.ReadOnly =
      zio.aws.proton.model.ServiceTemplate.wrap(impl.serviceTemplate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.GetServiceTemplateResponse
  ): zio.aws.proton.model.GetServiceTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
