package zio.aws.proton.model
import zio.aws.proton.model.primitives.{EmptyNextToken, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListComponentProvisionedResourcesRequest(
    componentName: ResourceName,
    nextToken: Optional[EmptyNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest = {
    import ListComponentProvisionedResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest
      .builder()
      .componentName(ResourceName.unwrap(componentName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListComponentProvisionedResourcesRequest.ReadOnly =
    zio.aws.proton.model.ListComponentProvisionedResourcesRequest
      .wrap(buildAwsValue())
}
object ListComponentProvisionedResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListComponentProvisionedResourcesRequest =
      zio.aws.proton.model.ListComponentProvisionedResourcesRequest(
        componentName,
        nextToken.map(value => value)
      )
    def componentName: ResourceName
    def nextToken: Optional[EmptyNextToken]
    def getComponentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(componentName)
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest
  ) extends zio.aws.proton.model.ListComponentProvisionedResourcesRequest.ReadOnly {
    override val componentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.componentName())
    override val nextToken: Optional[EmptyNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListComponentProvisionedResourcesRequest
  ): zio.aws.proton.model.ListComponentProvisionedResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
