package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListComponentsResponse(
    components: Iterable[zio.aws.proton.model.ComponentSummary],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListComponentsResponse = {
    import ListComponentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListComponentsResponse
      .builder()
      .components(components.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListComponentsResponse.ReadOnly =
    zio.aws.proton.model.ListComponentsResponse.wrap(buildAwsValue())
}
object ListComponentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListComponentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListComponentsResponse =
      zio.aws.proton.model.ListComponentsResponse(
        components.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def components: List[zio.aws.proton.model.ComponentSummary.ReadOnly]
    def nextToken: Optional[NextToken]
    def getComponents: ZIO[Any, Nothing, List[
      zio.aws.proton.model.ComponentSummary.ReadOnly
    ]] = ZIO.succeed(components)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListComponentsResponse
  ) extends zio.aws.proton.model.ListComponentsResponse.ReadOnly {
    override val components
        : List[zio.aws.proton.model.ComponentSummary.ReadOnly] = impl
      .components()
      .asScala
      .map { item =>
        zio.aws.proton.model.ComponentSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListComponentsResponse
  ): zio.aws.proton.model.ListComponentsResponse.ReadOnly = new Wrapper(impl)
}
