package zio.aws.proton.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.proton.model.primitives.{NextToken, MaxPageResults, ResourceName}
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentAccountConnectionsRequest(
    environmentName: Optional[ResourceName] = Optional.Absent,
    maxResults: Optional[MaxPageResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    requestedBy: zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType,
    statuses: Optional[
      Iterable[zio.aws.proton.model.EnvironmentAccountConnectionStatus]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest = {
    import ListEnvironmentAccountConnectionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest
      .builder()
      .optionallyWith(
        environmentName.map(value =>
          ResourceName.unwrap(value): java.lang.String
        )
      )(_.environmentName)
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .requestedBy(requestedBy.unwrap)
      .optionallyWith(
        statuses.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.statusesWithStrings)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest.ReadOnly =
    zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest
      .wrap(buildAwsValue())
}
object ListEnvironmentAccountConnectionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest =
      zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest(
        environmentName.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        requestedBy,
        statuses.map(value => value)
      )
    def environmentName: Optional[ResourceName]
    def maxResults: Optional[MaxPageResults]
    def nextToken: Optional[NextToken]
    def requestedBy
        : zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType
    def statuses: Optional[
      List[zio.aws.proton.model.EnvironmentAccountConnectionStatus]
    ]
    def getEnvironmentName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("environmentName", environmentName)
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRequestedBy: ZIO[
      Any,
      Nothing,
      zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType
    ] = ZIO.succeed(requestedBy)
    def getStatuses: ZIO[Any, AwsError, List[
      zio.aws.proton.model.EnvironmentAccountConnectionStatus
    ]] = AwsError.unwrapOptionField("statuses", statuses)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest
  ) extends zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest.ReadOnly {
    override val environmentName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.environmentName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val maxResults: Optional[MaxPageResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val requestedBy
        : zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType =
      zio.aws.proton.model.EnvironmentAccountConnectionRequesterAccountType
        .wrap(impl.requestedBy())
    override val statuses: Optional[
      List[zio.aws.proton.model.EnvironmentAccountConnectionStatus]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statuses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.EnvironmentAccountConnectionStatus.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsRequest
  ): zio.aws.proton.model.ListEnvironmentAccountConnectionsRequest.ReadOnly =
    new Wrapper(impl)
}
