package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentAccountConnectionsResponse(
    environmentAccountConnections: Iterable[
      zio.aws.proton.model.EnvironmentAccountConnectionSummary
    ],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse = {
    import ListEnvironmentAccountConnectionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse
      .builder()
      .environmentAccountConnections(environmentAccountConnections.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse.ReadOnly =
    zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse
      .wrap(buildAwsValue())
}
object ListEnvironmentAccountConnectionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse =
      zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse(
        environmentAccountConnections.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def environmentAccountConnections: List[
      zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly
    ]
    def nextToken: Optional[NextToken]
    def getEnvironmentAccountConnections: ZIO[Any, Nothing, List[
      zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly
    ]] = ZIO.succeed(environmentAccountConnections)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse
  ) extends zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse.ReadOnly {
    override val environmentAccountConnections: List[
      zio.aws.proton.model.EnvironmentAccountConnectionSummary.ReadOnly
    ] = impl
      .environmentAccountConnections()
      .asScala
      .map { item =>
        zio.aws.proton.model.EnvironmentAccountConnectionSummary.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentAccountConnectionsResponse
  ): zio.aws.proton.model.ListEnvironmentAccountConnectionsResponse.ReadOnly =
    new Wrapper(impl)
}
