package zio.aws.proton.model
import zio.aws.proton.model.primitives.{EmptyNextToken, ResourceName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEnvironmentProvisionedResourcesRequest(
    environmentName: ResourceName,
    nextToken: Optional[EmptyNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest = {
    import ListEnvironmentProvisionedResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest
      .builder()
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListEnvironmentProvisionedResourcesRequest.ReadOnly =
    zio.aws.proton.model.ListEnvironmentProvisionedResourcesRequest
      .wrap(buildAwsValue())
}
object ListEnvironmentProvisionedResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListEnvironmentProvisionedResourcesRequest =
      zio.aws.proton.model.ListEnvironmentProvisionedResourcesRequest(
        environmentName,
        nextToken.map(value => value)
      )
    def environmentName: ResourceName
    def nextToken: Optional[EmptyNextToken]
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest
  ) extends zio.aws.proton.model.ListEnvironmentProvisionedResourcesRequest.ReadOnly {
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val nextToken: Optional[EmptyNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListEnvironmentProvisionedResourcesRequest
  ): zio.aws.proton.model.ListEnvironmentProvisionedResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
