package zio.aws.proton.model
import zio.aws.proton.model.primitives.{RepositoryName, EmptyNextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRepositorySyncDefinitionsRequest(
    nextToken: Optional[EmptyNextToken] = Optional.Absent,
    repositoryName: RepositoryName,
    repositoryProvider: zio.aws.proton.model.RepositoryProvider,
    syncType: zio.aws.proton.model.SyncType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest = {
    import ListRepositorySyncDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .repositoryProvider(repositoryProvider.unwrap)
      .syncType(syncType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListRepositorySyncDefinitionsRequest.ReadOnly =
    zio.aws.proton.model.ListRepositorySyncDefinitionsRequest
      .wrap(buildAwsValue())
}
object ListRepositorySyncDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListRepositorySyncDefinitionsRequest =
      zio.aws.proton.model.ListRepositorySyncDefinitionsRequest(
        nextToken.map(value => value),
        repositoryName,
        repositoryProvider,
        syncType
      )
    def nextToken: Optional[EmptyNextToken]
    def repositoryName: RepositoryName
    def repositoryProvider: zio.aws.proton.model.RepositoryProvider
    def syncType: zio.aws.proton.model.SyncType
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getRepositoryProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(repositoryProvider)
    def getSyncType: ZIO[Any, Nothing, zio.aws.proton.model.SyncType] =
      ZIO.succeed(syncType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest
  ) extends zio.aws.proton.model.ListRepositorySyncDefinitionsRequest.ReadOnly {
    override val nextToken: Optional[EmptyNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val repositoryName: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.repositoryName())
    override val repositoryProvider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.repositoryProvider())
    override val syncType: zio.aws.proton.model.SyncType =
      zio.aws.proton.model.SyncType.wrap(impl.syncType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsRequest
  ): zio.aws.proton.model.ListRepositorySyncDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
