package zio.aws.proton.model
import zio.aws.proton.model.primitives.EmptyNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRepositorySyncDefinitionsResponse(
    nextToken: Optional[EmptyNextToken] = Optional.Absent,
    syncDefinitions: Iterable[zio.aws.proton.model.RepositorySyncDefinition]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse = {
    import ListRepositorySyncDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .syncDefinitions(syncDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListRepositorySyncDefinitionsResponse.ReadOnly =
    zio.aws.proton.model.ListRepositorySyncDefinitionsResponse
      .wrap(buildAwsValue())
}
object ListRepositorySyncDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListRepositorySyncDefinitionsResponse =
      zio.aws.proton.model.ListRepositorySyncDefinitionsResponse(
        nextToken.map(value => value),
        syncDefinitions.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[EmptyNextToken]
    def syncDefinitions
        : List[zio.aws.proton.model.RepositorySyncDefinition.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getSyncDefinitions: ZIO[Any, Nothing, List[
      zio.aws.proton.model.RepositorySyncDefinition.ReadOnly
    ]] = ZIO.succeed(syncDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse
  ) extends zio.aws.proton.model.ListRepositorySyncDefinitionsResponse.ReadOnly {
    override val nextToken: Optional[EmptyNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val syncDefinitions
        : List[zio.aws.proton.model.RepositorySyncDefinition.ReadOnly] = impl
      .syncDefinitions()
      .asScala
      .map { item =>
        zio.aws.proton.model.RepositorySyncDefinition.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListRepositorySyncDefinitionsResponse
  ): zio.aws.proton.model.ListRepositorySyncDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
