package zio.aws.proton.model
import zio.aws.proton.model.primitives.{ResourceName, EmptyNextToken}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListServiceInstanceProvisionedResourcesRequest(
    nextToken: Optional[EmptyNextToken] = Optional.Absent,
    serviceInstanceName: ResourceName,
    serviceName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest = {
    import ListServiceInstanceProvisionedResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest
      .builder()
      .optionallyWith(
        nextToken.map(value => EmptyNextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serviceInstanceName(
        ResourceName.unwrap(serviceInstanceName): java.lang.String
      )
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.ListServiceInstanceProvisionedResourcesRequest.ReadOnly =
    zio.aws.proton.model.ListServiceInstanceProvisionedResourcesRequest
      .wrap(buildAwsValue())
}
object ListServiceInstanceProvisionedResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.ListServiceInstanceProvisionedResourcesRequest =
      zio.aws.proton.model.ListServiceInstanceProvisionedResourcesRequest(
        nextToken.map(value => value),
        serviceInstanceName,
        serviceName
      )
    def nextToken: Optional[EmptyNextToken]
    def serviceInstanceName: ResourceName
    def serviceName: ResourceName
    def getNextToken: ZIO[Any, AwsError, EmptyNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceInstanceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceInstanceName)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest
  ) extends zio.aws.proton.model.ListServiceInstanceProvisionedResourcesRequest.ReadOnly {
    override val nextToken: Optional[EmptyNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.EmptyNextToken(value))
    override val serviceInstanceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceInstanceName())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstanceProvisionedResourcesRequest
  ): zio.aws.proton.model.ListServiceInstanceProvisionedResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
