package zio.aws.proton.model
import zio.aws.proton.model.primitives.ListServiceInstancesFilterValue
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListServiceInstancesFilter(
    key: Optional[zio.aws.proton.model.ListServiceInstancesFilterBy] =
      Optional.Absent,
    value: Optional[ListServiceInstancesFilterValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceInstancesFilter = {
    import ListServiceInstancesFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceInstancesFilter
      .builder()
      .optionallyWith(key.map(value => value.unwrap))(_.key)
      .optionallyWith(
        value.map(value =>
          ListServiceInstancesFilterValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListServiceInstancesFilter.ReadOnly =
    zio.aws.proton.model.ListServiceInstancesFilter.wrap(buildAwsValue())
}
object ListServiceInstancesFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceInstancesFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServiceInstancesFilter =
      zio.aws.proton.model.ListServiceInstancesFilter(
        key.map(value => value),
        value.map(value => value)
      )
    def key: Optional[zio.aws.proton.model.ListServiceInstancesFilterBy]
    def value: Optional[ListServiceInstancesFilterValue]
    def getKey: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.ListServiceInstancesFilterBy
    ] = AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, ListServiceInstancesFilterValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesFilter
  ) extends zio.aws.proton.model.ListServiceInstancesFilter.ReadOnly {
    override val key
        : Optional[zio.aws.proton.model.ListServiceInstancesFilterBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.key())
        .map(value =>
          zio.aws.proton.model.ListServiceInstancesFilterBy.wrap(value)
        )
    override val value: Optional[ListServiceInstancesFilterValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.proton.model.primitives.ListServiceInstancesFilterValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesFilter
  ): zio.aws.proton.model.ListServiceInstancesFilter.ReadOnly = new Wrapper(
    impl
  )
}
