package zio.aws.proton.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.proton.model.primitives.{ResourceName, NextToken, MaxPageResults}
import scala.jdk.CollectionConverters.*
final case class ListServiceInstancesRequest(
    filters: Optional[
      Iterable[zio.aws.proton.model.ListServiceInstancesFilter]
    ] = Optional.Absent,
    maxResults: Optional[MaxPageResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    serviceName: Optional[ResourceName] = Optional.Absent,
    sortBy: Optional[zio.aws.proton.model.ListServiceInstancesSortBy] =
      Optional.Absent,
    sortOrder: Optional[zio.aws.proton.model.SortOrder] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest = {
    import ListServiceInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxPageResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        serviceName.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .optionallyWith(sortBy.map(value => value.unwrap))(_.sortBy)
      .optionallyWith(sortOrder.map(value => value.unwrap))(_.sortOrder)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListServiceInstancesRequest.ReadOnly =
    zio.aws.proton.model.ListServiceInstancesRequest.wrap(buildAwsValue())
}
object ListServiceInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServiceInstancesRequest =
      zio.aws.proton.model.ListServiceInstancesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value),
        serviceName.map(value => value),
        sortBy.map(value => value),
        sortOrder.map(value => value)
      )
    def filters: Optional[
      List[zio.aws.proton.model.ListServiceInstancesFilter.ReadOnly]
    ]
    def maxResults: Optional[MaxPageResults]
    def nextToken: Optional[NextToken]
    def serviceName: Optional[ResourceName]
    def sortBy: Optional[zio.aws.proton.model.ListServiceInstancesSortBy]
    def sortOrder: Optional[zio.aws.proton.model.SortOrder]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.proton.model.ListServiceInstancesFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxPageResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
    def getSortBy
        : ZIO[Any, AwsError, zio.aws.proton.model.ListServiceInstancesSortBy] =
      AwsError.unwrapOptionField("sortBy", sortBy)
    def getSortOrder: ZIO[Any, AwsError, zio.aws.proton.model.SortOrder] =
      AwsError.unwrapOptionField("sortOrder", sortOrder)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
  ) extends zio.aws.proton.model.ListServiceInstancesRequest.ReadOnly {
    override val filters: Optional[
      List[zio.aws.proton.model.ListServiceInstancesFilter.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.proton.model.ListServiceInstancesFilter.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxPageResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.proton.model.primitives.MaxPageResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val serviceName: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.proton.model.primitives.ResourceName(value))
    override val sortBy
        : Optional[zio.aws.proton.model.ListServiceInstancesSortBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortBy())
        .map(value =>
          zio.aws.proton.model.ListServiceInstancesSortBy.wrap(value)
        )
    override val sortOrder: Optional[zio.aws.proton.model.SortOrder] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sortOrder())
        .map(value => zio.aws.proton.model.SortOrder.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesRequest
  ): zio.aws.proton.model.ListServiceInstancesRequest.ReadOnly = new Wrapper(
    impl
  )
}
