package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListServiceInstancesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    serviceInstances: Iterable[zio.aws.proton.model.ServiceInstanceSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse = {
    import ListServiceInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .serviceInstances(serviceInstances.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListServiceInstancesResponse.ReadOnly =
    zio.aws.proton.model.ListServiceInstancesResponse.wrap(buildAwsValue())
}
object ListServiceInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServiceInstancesResponse =
      zio.aws.proton.model.ListServiceInstancesResponse(
        nextToken.map(value => value),
        serviceInstances.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def serviceInstances
        : List[zio.aws.proton.model.ServiceInstanceSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getServiceInstances: ZIO[Any, Nothing, List[
      zio.aws.proton.model.ServiceInstanceSummary.ReadOnly
    ]] = ZIO.succeed(serviceInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse
  ) extends zio.aws.proton.model.ListServiceInstancesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val serviceInstances
        : List[zio.aws.proton.model.ServiceInstanceSummary.ReadOnly] = impl
      .serviceInstances()
      .asScala
      .map { item =>
        zio.aws.proton.model.ServiceInstanceSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceInstancesResponse
  ): zio.aws.proton.model.ListServiceInstancesResponse.ReadOnly = new Wrapper(
    impl
  )
}
