package zio.aws.proton.model
import zio.aws.proton.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListServiceTemplatesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    templates: Iterable[zio.aws.proton.model.ServiceTemplateSummary]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse = {
    import ListServiceTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .templates(templates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ListServiceTemplatesResponse.ReadOnly =
    zio.aws.proton.model.ListServiceTemplatesResponse.wrap(buildAwsValue())
}
object ListServiceTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ListServiceTemplatesResponse =
      zio.aws.proton.model.ListServiceTemplatesResponse(
        nextToken.map(value => value),
        templates.map { item =>
          item.asEditable
        }
      )
    def nextToken: Optional[NextToken]
    def templates: List[zio.aws.proton.model.ServiceTemplateSummary.ReadOnly]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTemplates: ZIO[Any, Nothing, List[
      zio.aws.proton.model.ServiceTemplateSummary.ReadOnly
    ]] = ZIO.succeed(templates)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse
  ) extends zio.aws.proton.model.ListServiceTemplatesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.proton.model.primitives.NextToken(value))
    override val templates
        : List[zio.aws.proton.model.ServiceTemplateSummary.ReadOnly] = impl
      .templates()
      .asScala
      .map { item =>
        zio.aws.proton.model.ServiceTemplateSummary.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ListServiceTemplatesResponse
  ): zio.aws.proton.model.ListServiceTemplatesResponse.ReadOnly = new Wrapper(
    impl
  )
}
