package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  NotifyResourceDeploymentStatusChangeInputStatusMessageString,
  Arn,
  DeploymentId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class NotifyResourceDeploymentStatusChangeRequest(
    deploymentId: Optional[DeploymentId] = Optional.Absent,
    outputs: Optional[Iterable[zio.aws.proton.model.Output]] = Optional.Absent,
    resourceArn: Arn,
    status: Optional[zio.aws.proton.model.ResourceDeploymentStatus] =
      Optional.Absent,
    statusMessage: Optional[
      NotifyResourceDeploymentStatusChangeInputStatusMessageString
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest = {
    import NotifyResourceDeploymentStatusChangeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest
      .builder()
      .optionallyWith(
        deploymentId.map(value => DeploymentId.unwrap(value): java.lang.String)
      )(_.deploymentId)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          NotifyResourceDeploymentStatusChangeInputStatusMessageString.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest.ReadOnly =
    zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest
      .wrap(buildAwsValue())
}
object NotifyResourceDeploymentStatusChangeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest =
      zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest(
        deploymentId.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceArn,
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def deploymentId: Optional[DeploymentId]
    def outputs: Optional[List[zio.aws.proton.model.Output.ReadOnly]]
    def resourceArn: Arn
    def status: Optional[zio.aws.proton.model.ResourceDeploymentStatus]
    def statusMessage
        : Optional[NotifyResourceDeploymentStatusChangeInputStatusMessageString]
    def getDeploymentId: ZIO[Any, AwsError, DeploymentId] =
      AwsError.unwrapOptionField("deploymentId", deploymentId)
    def getOutputs
        : ZIO[Any, AwsError, List[zio.aws.proton.model.Output.ReadOnly]] =
      AwsError.unwrapOptionField("outputs", outputs)
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.proton.model.ResourceDeploymentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[
      Any,
      AwsError,
      NotifyResourceDeploymentStatusChangeInputStatusMessageString
    ] = AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest
  ) extends zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest.ReadOnly {
    override val deploymentId: Optional[DeploymentId] = zio.aws.core.internal
      .optionalFromNullable(impl.deploymentId())
      .map(value => zio.aws.proton.model.primitives.DeploymentId(value))
    override val outputs: Optional[List[zio.aws.proton.model.Output.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.Output.wrap(item)
          }.toList
        )
    override val resourceArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.resourceArn())
    override val status
        : Optional[zio.aws.proton.model.ResourceDeploymentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.proton.model.ResourceDeploymentStatus.wrap(value))
    override val statusMessage: Optional[
      NotifyResourceDeploymentStatusChangeInputStatusMessageString
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value =>
        zio.aws.proton.model.primitives
          .NotifyResourceDeploymentStatusChangeInputStatusMessageString(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.NotifyResourceDeploymentStatusChangeRequest
  ): zio.aws.proton.model.NotifyResourceDeploymentStatusChangeRequest.ReadOnly =
    new Wrapper(impl)
}
