package zio.aws.proton.model
import zio.aws.proton.model.primitives.{OutputValueString, OutputKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Output(
    key: Optional[OutputKey] = Optional.Absent,
    valueString: Optional[OutputValueString] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.proton.model.Output = {
    import Output.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.Output
      .builder()
      .optionallyWith(
        key.map(value => OutputKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        valueString.map(value =>
          OutputValueString.unwrap(value): java.lang.String
        )
      )(_.valueString)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.Output.ReadOnly =
    zio.aws.proton.model.Output.wrap(buildAwsValue())
}
object Output {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.proton.model.Output] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.Output = zio.aws.proton.model
      .Output(key.map(value => value), valueString.map(value => value))
    def key: Optional[OutputKey]
    def valueString: Optional[OutputValueString]
    def getKey: ZIO[Any, AwsError, OutputKey] =
      AwsError.unwrapOptionField("key", key)
    def getValueString: ZIO[Any, AwsError, OutputValueString] =
      AwsError.unwrapOptionField("valueString", valueString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.Output
  ) extends zio.aws.proton.model.Output.ReadOnly {
    override val key: Optional[OutputKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.proton.model.primitives.OutputKey(value))
    override val valueString: Optional[OutputValueString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.valueString())
        .map(value => zio.aws.proton.model.primitives.OutputValueString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.Output
  ): zio.aws.proton.model.Output.ReadOnly = new Wrapper(impl)
}
