package zio.aws.proton.model
import scala.jdk.CollectionConverters.*
sealed trait ProvisionedResourceEngine {
  def unwrap
      : software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine
}
object ProvisionedResourceEngine {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine
  ): zio.aws.proton.model.ProvisionedResourceEngine = value match {
    case software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine.CLOUDFORMATION =>
      val r = CLOUDFORMATION
      r
    case software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine.TERRAFORM =>
      val r = TERRAFORM
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.ProvisionedResourceEngine {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine =
      software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUDFORMATION
      extends zio.aws.proton.model.ProvisionedResourceEngine {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine =
      software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine.CLOUDFORMATION
  }
  case object TERRAFORM extends zio.aws.proton.model.ProvisionedResourceEngine {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine =
      software.amazon.awssdk.services.proton.model.ProvisionedResourceEngine.TERRAFORM
  }
}
