package zio.aws.proton.model
import scala.jdk.CollectionConverters.*
sealed trait Provisioning {
  def unwrap: software.amazon.awssdk.services.proton.model.Provisioning
}
object Provisioning {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.Provisioning
  ): zio.aws.proton.model.Provisioning = value match {
    case software.amazon.awssdk.services.proton.model.Provisioning.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.Provisioning.CUSTOMER_MANAGED =>
      val r = CUSTOMER_MANAGED
      r
  }
  case object unknownToSdkVersion extends zio.aws.proton.model.Provisioning {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.Provisioning =
      software.amazon.awssdk.services.proton.model.Provisioning.UNKNOWN_TO_SDK_VERSION
  }
  case object CUSTOMER_MANAGED extends zio.aws.proton.model.Provisioning {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.Provisioning =
      software.amazon.awssdk.services.proton.model.Provisioning.CUSTOMER_MANAGED
  }
}
