package zio.aws.proton.model
import zio.aws.proton.model.primitives.EnvironmentAccountConnectionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RejectEnvironmentAccountConnectionRequest(
    id: EnvironmentAccountConnectionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionRequest = {
    import RejectEnvironmentAccountConnectionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionRequest
      .builder()
      .id(EnvironmentAccountConnectionId.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.proton.model.RejectEnvironmentAccountConnectionRequest.ReadOnly =
    zio.aws.proton.model.RejectEnvironmentAccountConnectionRequest
      .wrap(buildAwsValue())
}
object RejectEnvironmentAccountConnectionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.proton.model.RejectEnvironmentAccountConnectionRequest =
      zio.aws.proton.model.RejectEnvironmentAccountConnectionRequest(id)
    def id: EnvironmentAccountConnectionId
    def getId: ZIO[Any, Nothing, EnvironmentAccountConnectionId] =
      ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionRequest
  ) extends zio.aws.proton.model.RejectEnvironmentAccountConnectionRequest.ReadOnly {
    override val id: EnvironmentAccountConnectionId =
      zio.aws.proton.model.primitives.EnvironmentAccountConnectionId(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.RejectEnvironmentAccountConnectionRequest
  ): zio.aws.proton.model.RejectEnvironmentAccountConnectionRequest.ReadOnly =
    new Wrapper(impl)
}
