package zio.aws.proton.model
import zio.aws.proton.model.primitives.{
  RepositoryName,
  GitBranchName,
  RepositoryArn
}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RepositoryBranch(
    arn: RepositoryArn,
    branch: GitBranchName,
    name: RepositoryName,
    provider: zio.aws.proton.model.RepositoryProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.RepositoryBranch = {
    import RepositoryBranch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.RepositoryBranch
      .builder()
      .arn(RepositoryArn.unwrap(arn): java.lang.String)
      .branch(GitBranchName.unwrap(branch): java.lang.String)
      .name(RepositoryName.unwrap(name): java.lang.String)
      .provider(provider.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.RepositoryBranch.ReadOnly =
    zio.aws.proton.model.RepositoryBranch.wrap(buildAwsValue())
}
object RepositoryBranch {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.RepositoryBranch
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.RepositoryBranch =
      zio.aws.proton.model.RepositoryBranch(arn, branch, name, provider)
    def arn: RepositoryArn
    def branch: GitBranchName
    def name: RepositoryName
    def provider: zio.aws.proton.model.RepositoryProvider
    def getArn: ZIO[Any, Nothing, RepositoryArn] = ZIO.succeed(arn)
    def getBranch: ZIO[Any, Nothing, GitBranchName] = ZIO.succeed(branch)
    def getName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(name)
    def getProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(provider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.RepositoryBranch
  ) extends zio.aws.proton.model.RepositoryBranch.ReadOnly {
    override val arn: RepositoryArn =
      zio.aws.proton.model.primitives.RepositoryArn(impl.arn())
    override val branch: GitBranchName =
      zio.aws.proton.model.primitives.GitBranchName(impl.branch())
    override val name: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.name())
    override val provider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.provider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.RepositoryBranch
  ): zio.aws.proton.model.RepositoryBranch.ReadOnly = new Wrapper(impl)
}
