package zio.aws.proton.model
import zio.aws.proton.model.primitives.{RepositoryName, GitBranchName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RepositoryBranchInput(
    branch: GitBranchName,
    name: RepositoryName,
    provider: zio.aws.proton.model.RepositoryProvider
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.RepositoryBranchInput = {
    import RepositoryBranchInput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.RepositoryBranchInput
      .builder()
      .branch(GitBranchName.unwrap(branch): java.lang.String)
      .name(RepositoryName.unwrap(name): java.lang.String)
      .provider(provider.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.RepositoryBranchInput.ReadOnly =
    zio.aws.proton.model.RepositoryBranchInput.wrap(buildAwsValue())
}
object RepositoryBranchInput {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.RepositoryBranchInput
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.RepositoryBranchInput =
      zio.aws.proton.model.RepositoryBranchInput(branch, name, provider)
    def branch: GitBranchName
    def name: RepositoryName
    def provider: zio.aws.proton.model.RepositoryProvider
    def getBranch: ZIO[Any, Nothing, GitBranchName] = ZIO.succeed(branch)
    def getName: ZIO[Any, Nothing, RepositoryName] = ZIO.succeed(name)
    def getProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(provider)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.RepositoryBranchInput
  ) extends zio.aws.proton.model.RepositoryBranchInput.ReadOnly {
    override val branch: GitBranchName =
      zio.aws.proton.model.primitives.GitBranchName(impl.branch())
    override val name: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.name())
    override val provider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.provider())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.RepositoryBranchInput
  ): zio.aws.proton.model.RepositoryBranchInput.ReadOnly = new Wrapper(impl)
}
