package zio.aws.proton.model
import scala.jdk.CollectionConverters.*
sealed trait RepositoryProvider {
  def unwrap: software.amazon.awssdk.services.proton.model.RepositoryProvider
}
object RepositoryProvider {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.RepositoryProvider
  ): zio.aws.proton.model.RepositoryProvider = value match {
    case software.amazon.awssdk.services.proton.model.RepositoryProvider.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.RepositoryProvider.GITHUB =>
      val r = GITHUB
      r
    case software.amazon.awssdk.services.proton.model.RepositoryProvider.GITHUB_ENTERPRISE =>
      val r = GITHUB_ENTERPRISE
      r
    case software.amazon.awssdk.services.proton.model.RepositoryProvider.BITBUCKET =>
      val r = BITBUCKET
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.RepositoryProvider {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositoryProvider =
      software.amazon.awssdk.services.proton.model.RepositoryProvider.UNKNOWN_TO_SDK_VERSION
  }
  case object GITHUB extends zio.aws.proton.model.RepositoryProvider {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositoryProvider =
      software.amazon.awssdk.services.proton.model.RepositoryProvider.GITHUB
  }
  case object GITHUB_ENTERPRISE
      extends zio.aws.proton.model.RepositoryProvider {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositoryProvider =
      software.amazon.awssdk.services.proton.model.RepositoryProvider.GITHUB_ENTERPRISE
  }
  case object BITBUCKET extends zio.aws.proton.model.RepositoryProvider {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.RepositoryProvider =
      software.amazon.awssdk.services.proton.model.RepositoryProvider.BITBUCKET
  }
}
