package zio.aws.proton.model
import zio.aws.proton.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class RepositorySyncAttempt(
    events: Iterable[zio.aws.proton.model.RepositorySyncEvent],
    startedAt: Timestamp,
    status: zio.aws.proton.model.RepositorySyncStatus
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.RepositorySyncAttempt = {
    import RepositorySyncAttempt.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.RepositorySyncAttempt
      .builder()
      .events(events.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .startedAt(Timestamp.unwrap(startedAt): Instant)
      .status(status.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.RepositorySyncAttempt.ReadOnly =
    zio.aws.proton.model.RepositorySyncAttempt.wrap(buildAwsValue())
}
object RepositorySyncAttempt {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.RepositorySyncAttempt
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.RepositorySyncAttempt =
      zio.aws.proton.model.RepositorySyncAttempt(
        events.map { item =>
          item.asEditable
        },
        startedAt,
        status
      )
    def events: List[zio.aws.proton.model.RepositorySyncEvent.ReadOnly]
    def startedAt: Timestamp
    def status: zio.aws.proton.model.RepositorySyncStatus
    def getEvents: ZIO[Any, Nothing, List[
      zio.aws.proton.model.RepositorySyncEvent.ReadOnly
    ]] = ZIO.succeed(events)
    def getStartedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startedAt)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositorySyncStatus] =
      ZIO.succeed(status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.RepositorySyncAttempt
  ) extends zio.aws.proton.model.RepositorySyncAttempt.ReadOnly {
    override val events
        : List[zio.aws.proton.model.RepositorySyncEvent.ReadOnly] = impl
      .events()
      .asScala
      .map { item =>
        zio.aws.proton.model.RepositorySyncEvent.wrap(item)
      }
      .toList
    override val startedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.startedAt())
    override val status: zio.aws.proton.model.RepositorySyncStatus =
      zio.aws.proton.model.RepositorySyncStatus.wrap(impl.status())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.RepositorySyncAttempt
  ): zio.aws.proton.model.RepositorySyncAttempt.ReadOnly = new Wrapper(impl)
}
