package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class RepositorySyncEvent(
    event: String,
    externalId: Optional[String] = Optional.Absent,
    time: Timestamp,
    `type`: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.RepositorySyncEvent = {
    import RepositorySyncEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.RepositorySyncEvent
      .builder()
      .event(event: java.lang.String)
      .optionallyWith(externalId.map(value => value: java.lang.String))(
        _.externalId
      )
      .time(Timestamp.unwrap(time): Instant)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.RepositorySyncEvent.ReadOnly =
    zio.aws.proton.model.RepositorySyncEvent.wrap(buildAwsValue())
}
object RepositorySyncEvent {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.RepositorySyncEvent
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.RepositorySyncEvent =
      zio.aws.proton.model.RepositorySyncEvent(
        event,
        externalId.map(value => value),
        time,
        `type`
      )
    def event: String
    def externalId: Optional[String]
    def time: Timestamp
    def `type`: String
    def getEvent: ZIO[Any, Nothing, String] = ZIO.succeed(event)
    def getExternalId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("externalId", externalId)
    def getTime: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(time)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.RepositorySyncEvent
  ) extends zio.aws.proton.model.RepositorySyncEvent.ReadOnly {
    override val event: String = impl.event(): String
    override val externalId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.externalId())
      .map(value => value: String)
    override val time: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.time())
    override val `type`: String = impl.`type`(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.RepositorySyncEvent
  ): zio.aws.proton.model.RepositorySyncEvent.ReadOnly = new Wrapper(impl)
}
