package zio.aws.proton.model
import zio.aws.proton.model.primitives.Timestamp
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ResourceSyncAttempt(
    events: Iterable[zio.aws.proton.model.ResourceSyncEvent],
    initialRevision: zio.aws.proton.model.Revision,
    startedAt: Timestamp,
    status: zio.aws.proton.model.ResourceSyncStatus,
    target: String,
    targetRevision: zio.aws.proton.model.Revision
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ResourceSyncAttempt = {
    import ResourceSyncAttempt.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ResourceSyncAttempt
      .builder()
      .events(events.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .initialRevision(initialRevision.buildAwsValue())
      .startedAt(Timestamp.unwrap(startedAt): Instant)
      .status(status.unwrap)
      .target(target: java.lang.String)
      .targetRevision(targetRevision.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ResourceSyncAttempt.ReadOnly =
    zio.aws.proton.model.ResourceSyncAttempt.wrap(buildAwsValue())
}
object ResourceSyncAttempt {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ResourceSyncAttempt
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ResourceSyncAttempt =
      zio.aws.proton.model.ResourceSyncAttempt(
        events.map { item =>
          item.asEditable
        },
        initialRevision.asEditable,
        startedAt,
        status,
        target,
        targetRevision.asEditable
      )
    def events: List[zio.aws.proton.model.ResourceSyncEvent.ReadOnly]
    def initialRevision: zio.aws.proton.model.Revision.ReadOnly
    def startedAt: Timestamp
    def status: zio.aws.proton.model.ResourceSyncStatus
    def target: String
    def targetRevision: zio.aws.proton.model.Revision.ReadOnly
    def getEvents: ZIO[Any, Nothing, List[
      zio.aws.proton.model.ResourceSyncEvent.ReadOnly
    ]] = ZIO.succeed(events)
    def getInitialRevision
        : ZIO[Any, Nothing, zio.aws.proton.model.Revision.ReadOnly] =
      ZIO.succeed(initialRevision)
    def getStartedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startedAt)
    def getStatus: ZIO[Any, Nothing, zio.aws.proton.model.ResourceSyncStatus] =
      ZIO.succeed(status)
    def getTarget: ZIO[Any, Nothing, String] = ZIO.succeed(target)
    def getTargetRevision
        : ZIO[Any, Nothing, zio.aws.proton.model.Revision.ReadOnly] =
      ZIO.succeed(targetRevision)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ResourceSyncAttempt
  ) extends zio.aws.proton.model.ResourceSyncAttempt.ReadOnly {
    override val events: List[zio.aws.proton.model.ResourceSyncEvent.ReadOnly] =
      impl
        .events()
        .asScala
        .map { item =>
          zio.aws.proton.model.ResourceSyncEvent.wrap(item)
        }
        .toList
    override val initialRevision: zio.aws.proton.model.Revision.ReadOnly =
      zio.aws.proton.model.Revision.wrap(impl.initialRevision())
    override val startedAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.startedAt())
    override val status: zio.aws.proton.model.ResourceSyncStatus =
      zio.aws.proton.model.ResourceSyncStatus.wrap(impl.status())
    override val target: String = impl.target(): String
    override val targetRevision: zio.aws.proton.model.Revision.ReadOnly =
      zio.aws.proton.model.Revision.wrap(impl.targetRevision())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ResourceSyncAttempt
  ): zio.aws.proton.model.ResourceSyncAttempt.ReadOnly = new Wrapper(impl)
}
