package zio.aws.proton.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceSyncStatus {
  def unwrap: software.amazon.awssdk.services.proton.model.ResourceSyncStatus
}
object ResourceSyncStatus {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.ResourceSyncStatus
  ): zio.aws.proton.model.ResourceSyncStatus = value match {
    case software.amazon.awssdk.services.proton.model.ResourceSyncStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.ResourceSyncStatus.INITIATED =>
      val r = INITIATED
      r
    case software.amazon.awssdk.services.proton.model.ResourceSyncStatus.IN_PROGRESS =>
      val r = IN_PROGRESS
      r
    case software.amazon.awssdk.services.proton.model.ResourceSyncStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.proton.model.ResourceSyncStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.ResourceSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ResourceSyncStatus =
      software.amazon.awssdk.services.proton.model.ResourceSyncStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object INITIATED extends zio.aws.proton.model.ResourceSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ResourceSyncStatus =
      software.amazon.awssdk.services.proton.model.ResourceSyncStatus.INITIATED
  }
  case object IN_PROGRESS extends zio.aws.proton.model.ResourceSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ResourceSyncStatus =
      software.amazon.awssdk.services.proton.model.ResourceSyncStatus.IN_PROGRESS
  }
  case object SUCCEEDED extends zio.aws.proton.model.ResourceSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ResourceSyncStatus =
      software.amazon.awssdk.services.proton.model.ResourceSyncStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.proton.model.ResourceSyncStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.ResourceSyncStatus =
      software.amazon.awssdk.services.proton.model.ResourceSyncStatus.FAILED
  }
}
