package zio.aws.proton.model
import zio.aws.proton.model.primitives.{SHA, RepositoryName, GitBranchName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Revision(
    branch: GitBranchName,
    directory: String,
    repositoryName: RepositoryName,
    repositoryProvider: zio.aws.proton.model.RepositoryProvider,
    sha: SHA
) {
  def buildAwsValue(): software.amazon.awssdk.services.proton.model.Revision = {
    import Revision.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.Revision
      .builder()
      .branch(GitBranchName.unwrap(branch): java.lang.String)
      .directory(directory: java.lang.String)
      .repositoryName(RepositoryName.unwrap(repositoryName): java.lang.String)
      .repositoryProvider(repositoryProvider.unwrap)
      .sha(SHA.unwrap(sha): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.Revision.ReadOnly =
    zio.aws.proton.model.Revision.wrap(buildAwsValue())
}
object Revision {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.proton.model.Revision] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.Revision = zio.aws.proton.model
      .Revision(branch, directory, repositoryName, repositoryProvider, sha)
    def branch: GitBranchName
    def directory: String
    def repositoryName: RepositoryName
    def repositoryProvider: zio.aws.proton.model.RepositoryProvider
    def sha: SHA
    def getBranch: ZIO[Any, Nothing, GitBranchName] = ZIO.succeed(branch)
    def getDirectory: ZIO[Any, Nothing, String] = ZIO.succeed(directory)
    def getRepositoryName: ZIO[Any, Nothing, RepositoryName] =
      ZIO.succeed(repositoryName)
    def getRepositoryProvider
        : ZIO[Any, Nothing, zio.aws.proton.model.RepositoryProvider] =
      ZIO.succeed(repositoryProvider)
    def getSha: ZIO[Any, Nothing, SHA] = ZIO.succeed(sha)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.Revision
  ) extends zio.aws.proton.model.Revision.ReadOnly {
    override val branch: GitBranchName =
      zio.aws.proton.model.primitives.GitBranchName(impl.branch())
    override val directory: String = impl.directory(): String
    override val repositoryName: RepositoryName =
      zio.aws.proton.model.primitives.RepositoryName(impl.repositoryName())
    override val repositoryProvider: zio.aws.proton.model.RepositoryProvider =
      zio.aws.proton.model.RepositoryProvider.wrap(impl.repositoryProvider())
    override val sha: SHA = zio.aws.proton.model.primitives.SHA(impl.sha())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.Revision
  ): zio.aws.proton.model.Revision.ReadOnly = new Wrapper(impl)
}
