package zio.aws.proton.model
import zio.aws.proton.model.primitives.{S3Key, S3Bucket}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class S3ObjectSource(bucket: S3Bucket, key: S3Key) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.S3ObjectSource = {
    import S3ObjectSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.S3ObjectSource
      .builder()
      .bucket(S3Bucket.unwrap(bucket): java.lang.String)
      .key(S3Key.unwrap(key): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.S3ObjectSource.ReadOnly =
    zio.aws.proton.model.S3ObjectSource.wrap(buildAwsValue())
}
object S3ObjectSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.S3ObjectSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.S3ObjectSource =
      zio.aws.proton.model.S3ObjectSource(bucket, key)
    def bucket: S3Bucket
    def key: S3Key
    def getBucket: ZIO[Any, Nothing, S3Bucket] = ZIO.succeed(bucket)
    def getKey: ZIO[Any, Nothing, S3Key] = ZIO.succeed(key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.S3ObjectSource
  ) extends zio.aws.proton.model.S3ObjectSource.ReadOnly {
    override val bucket: S3Bucket =
      zio.aws.proton.model.primitives.S3Bucket(impl.bucket())
    override val key: S3Key = zio.aws.proton.model.primitives.S3Key(impl.key())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.S3ObjectSource
  ): zio.aws.proton.model.S3ObjectSource.ReadOnly = new Wrapper(impl)
}
