package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.{
  TemplateVersionPart,
  Timestamp,
  SpecContents,
  ServiceInstanceArn,
  StatusMessage,
  ResourceName
}
import scala.jdk.CollectionConverters.*
final case class ServiceInstance(
    arn: ServiceInstanceArn,
    createdAt: Timestamp,
    deploymentStatus: zio.aws.proton.model.DeploymentStatus,
    deploymentStatusMessage: Optional[StatusMessage] = Optional.Absent,
    environmentName: ResourceName,
    lastClientRequestToken: Optional[String] = Optional.Absent,
    lastDeploymentAttemptedAt: Timestamp,
    lastDeploymentSucceededAt: Timestamp,
    name: ResourceName,
    serviceName: ResourceName,
    spec: Optional[SpecContents] = Optional.Absent,
    templateMajorVersion: TemplateVersionPart,
    templateMinorVersion: TemplateVersionPart,
    templateName: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.ServiceInstance = {
    import ServiceInstance.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.ServiceInstance
      .builder()
      .arn(ServiceInstanceArn.unwrap(arn): java.lang.String)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .deploymentStatus(deploymentStatus.unwrap)
      .optionallyWith(
        deploymentStatusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.deploymentStatusMessage)
      .environmentName(ResourceName.unwrap(environmentName): java.lang.String)
      .optionallyWith(
        lastClientRequestToken.map(value => value: java.lang.String)
      )(_.lastClientRequestToken)
      .lastDeploymentAttemptedAt(
        Timestamp.unwrap(lastDeploymentAttemptedAt): Instant
      )
      .lastDeploymentSucceededAt(
        Timestamp.unwrap(lastDeploymentSucceededAt): Instant
      )
      .name(ResourceName.unwrap(name): java.lang.String)
      .serviceName(ResourceName.unwrap(serviceName): java.lang.String)
      .optionallyWith(
        spec.map(value => SpecContents.unwrap(value): java.lang.String)
      )(_.spec)
      .templateMajorVersion(
        TemplateVersionPart.unwrap(templateMajorVersion): java.lang.String
      )
      .templateMinorVersion(
        TemplateVersionPart.unwrap(templateMinorVersion): java.lang.String
      )
      .templateName(ResourceName.unwrap(templateName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.ServiceInstance.ReadOnly =
    zio.aws.proton.model.ServiceInstance.wrap(buildAwsValue())
}
object ServiceInstance {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.ServiceInstance
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.ServiceInstance =
      zio.aws.proton.model.ServiceInstance(
        arn,
        createdAt,
        deploymentStatus,
        deploymentStatusMessage.map(value => value),
        environmentName,
        lastClientRequestToken.map(value => value),
        lastDeploymentAttemptedAt,
        lastDeploymentSucceededAt,
        name,
        serviceName,
        spec.map(value => value),
        templateMajorVersion,
        templateMinorVersion,
        templateName
      )
    def arn: ServiceInstanceArn
    def createdAt: Timestamp
    def deploymentStatus: zio.aws.proton.model.DeploymentStatus
    def deploymentStatusMessage: Optional[StatusMessage]
    def environmentName: ResourceName
    def lastClientRequestToken: Optional[String]
    def lastDeploymentAttemptedAt: Timestamp
    def lastDeploymentSucceededAt: Timestamp
    def name: ResourceName
    def serviceName: ResourceName
    def spec: Optional[SpecContents]
    def templateMajorVersion: TemplateVersionPart
    def templateMinorVersion: TemplateVersionPart
    def templateName: ResourceName
    def getArn: ZIO[Any, Nothing, ServiceInstanceArn] = ZIO.succeed(arn)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getDeploymentStatus
        : ZIO[Any, Nothing, zio.aws.proton.model.DeploymentStatus] =
      ZIO.succeed(deploymentStatus)
    def getDeploymentStatusMessage: ZIO[Any, AwsError, StatusMessage] = AwsError
      .unwrapOptionField("deploymentStatusMessage", deploymentStatusMessage)
    def getEnvironmentName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(environmentName)
    def getLastClientRequestToken: ZIO[Any, AwsError, String] = AwsError
      .unwrapOptionField("lastClientRequestToken", lastClientRequestToken)
    def getLastDeploymentAttemptedAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentAttemptedAt)
    def getLastDeploymentSucceededAt: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(lastDeploymentSucceededAt)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getServiceName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(serviceName)
    def getSpec: ZIO[Any, AwsError, SpecContents] =
      AwsError.unwrapOptionField("spec", spec)
    def getTemplateMajorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMajorVersion)
    def getTemplateMinorVersion: ZIO[Any, Nothing, TemplateVersionPart] =
      ZIO.succeed(templateMinorVersion)
    def getTemplateName: ZIO[Any, Nothing, ResourceName] =
      ZIO.succeed(templateName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.ServiceInstance
  ) extends zio.aws.proton.model.ServiceInstance.ReadOnly {
    override val arn: ServiceInstanceArn =
      zio.aws.proton.model.primitives.ServiceInstanceArn(impl.arn())
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val deploymentStatus: zio.aws.proton.model.DeploymentStatus =
      zio.aws.proton.model.DeploymentStatus.wrap(impl.deploymentStatus())
    override val deploymentStatusMessage: Optional[StatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deploymentStatusMessage())
        .map(value => zio.aws.proton.model.primitives.StatusMessage(value))
    override val environmentName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.environmentName())
    override val lastClientRequestToken: Optional[String] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastClientRequestToken())
        .map(value => value: String)
    override val lastDeploymentAttemptedAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentAttemptedAt())
    override val lastDeploymentSucceededAt: Timestamp =
      zio.aws.proton.model.primitives
        .Timestamp(impl.lastDeploymentSucceededAt())
    override val name: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.name())
    override val serviceName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.serviceName())
    override val spec: Optional[SpecContents] = zio.aws.core.internal
      .optionalFromNullable(impl.spec())
      .map(value => zio.aws.proton.model.primitives.SpecContents(value))
    override val templateMajorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMajorVersion())
    override val templateMinorVersion: TemplateVersionPart =
      zio.aws.proton.model.primitives
        .TemplateVersionPart(impl.templateMinorVersion())
    override val templateName: ResourceName =
      zio.aws.proton.model.primitives.ResourceName(impl.templateName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.ServiceInstance
  ): zio.aws.proton.model.ServiceInstance.ReadOnly = new Wrapper(impl)
}
