package zio.aws.proton.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.proton.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class SyncBlocker(
    contexts: Optional[Iterable[zio.aws.proton.model.SyncBlockerContext]] =
      Optional.Absent,
    createdAt: Timestamp,
    createdReason: String,
    id: String,
    resolvedAt: Optional[Timestamp] = Optional.Absent,
    resolvedReason: Optional[String] = Optional.Absent,
    status: zio.aws.proton.model.BlockerStatus,
    `type`: zio.aws.proton.model.BlockerType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.SyncBlocker = {
    import SyncBlocker.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.SyncBlocker
      .builder()
      .optionallyWith(
        contexts.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.contexts)
      .createdAt(Timestamp.unwrap(createdAt): Instant)
      .createdReason(createdReason: java.lang.String)
      .id(id: java.lang.String)
      .optionallyWith(
        resolvedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.resolvedAt)
      .optionallyWith(resolvedReason.map(value => value: java.lang.String))(
        _.resolvedReason
      )
      .status(status.unwrap)
      .`type`(`type`.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.SyncBlocker.ReadOnly =
    zio.aws.proton.model.SyncBlocker.wrap(buildAwsValue())
}
object SyncBlocker {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.SyncBlocker
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.SyncBlocker =
      zio.aws.proton.model.SyncBlocker(
        contexts.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt,
        createdReason,
        id,
        resolvedAt.map(value => value),
        resolvedReason.map(value => value),
        status,
        `type`
      )
    def contexts
        : Optional[List[zio.aws.proton.model.SyncBlockerContext.ReadOnly]]
    def createdAt: Timestamp
    def createdReason: String
    def id: String
    def resolvedAt: Optional[Timestamp]
    def resolvedReason: Optional[String]
    def status: zio.aws.proton.model.BlockerStatus
    def `type`: zio.aws.proton.model.BlockerType
    def getContexts: ZIO[Any, AwsError, List[
      zio.aws.proton.model.SyncBlockerContext.ReadOnly
    ]] = AwsError.unwrapOptionField("contexts", contexts)
    def getCreatedAt: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(createdAt)
    def getCreatedReason: ZIO[Any, Nothing, String] = ZIO.succeed(createdReason)
    def getId: ZIO[Any, Nothing, String] = ZIO.succeed(id)
    def getResolvedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("resolvedAt", resolvedAt)
    def getResolvedReason: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("resolvedReason", resolvedReason)
    def getStatus: ZIO[Any, Nothing, zio.aws.proton.model.BlockerStatus] =
      ZIO.succeed(status)
    def getType: ZIO[Any, Nothing, zio.aws.proton.model.BlockerType] =
      ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.SyncBlocker
  ) extends zio.aws.proton.model.SyncBlocker.ReadOnly {
    override val contexts
        : Optional[List[zio.aws.proton.model.SyncBlockerContext.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.contexts())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.proton.model.SyncBlockerContext.wrap(item)
          }.toList
        )
    override val createdAt: Timestamp =
      zio.aws.proton.model.primitives.Timestamp(impl.createdAt())
    override val createdReason: String = impl.createdReason(): String
    override val id: String = impl.id(): String
    override val resolvedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.resolvedAt())
      .map(value => zio.aws.proton.model.primitives.Timestamp(value))
    override val resolvedReason: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.resolvedReason())
      .map(value => value: String)
    override val status: zio.aws.proton.model.BlockerStatus =
      zio.aws.proton.model.BlockerStatus.wrap(impl.status())
    override val `type`: zio.aws.proton.model.BlockerType =
      zio.aws.proton.model.BlockerType.wrap(impl.`type`())
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.SyncBlocker
  ): zio.aws.proton.model.SyncBlocker.ReadOnly = new Wrapper(impl)
}
