package zio.aws.proton.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SyncBlockerContext(key: String, value: String) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.SyncBlockerContext = {
    import SyncBlockerContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.SyncBlockerContext
      .builder()
      .key(key: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.SyncBlockerContext.ReadOnly =
    zio.aws.proton.model.SyncBlockerContext.wrap(buildAwsValue())
}
object SyncBlockerContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.SyncBlockerContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.SyncBlockerContext =
      zio.aws.proton.model.SyncBlockerContext(key, value)
    def key: String
    def value: String
    def getKey: ZIO[Any, Nothing, String] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.SyncBlockerContext
  ) extends zio.aws.proton.model.SyncBlockerContext.ReadOnly {
    override val key: String = impl.key(): String
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.SyncBlockerContext
  ): zio.aws.proton.model.SyncBlockerContext.ReadOnly = new Wrapper(impl)
}
