package zio.aws.proton.model
import zio.aws.proton.model.primitives.Arn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Iterable[zio.aws.proton.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.TagResourceRequest.ReadOnly =
    zio.aws.proton.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.TagResourceRequest =
      zio.aws.proton.model.TagResourceRequest(
        resourceArn,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceArn: Arn
    def tags: List[zio.aws.proton.model.Tag.ReadOnly]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, List[zio.aws.proton.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.TagResourceRequest
  ) extends zio.aws.proton.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.proton.model.primitives.Arn(impl.resourceArn())
    override val tags: List[zio.aws.proton.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.proton.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.TagResourceRequest
  ): zio.aws.proton.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
