package zio.aws.proton.model
import scala.jdk.CollectionConverters.*
sealed trait TemplateType {
  def unwrap: software.amazon.awssdk.services.proton.model.TemplateType
}
object TemplateType {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.TemplateType
  ): zio.aws.proton.model.TemplateType = value match {
    case software.amazon.awssdk.services.proton.model.TemplateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.TemplateType.ENVIRONMENT =>
      val r = ENVIRONMENT
      r
    case software.amazon.awssdk.services.proton.model.TemplateType.SERVICE =>
      val r = SERVICE
      r
  }
  case object unknownToSdkVersion extends zio.aws.proton.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.TemplateType =
      software.amazon.awssdk.services.proton.model.TemplateType.UNKNOWN_TO_SDK_VERSION
  }
  case object ENVIRONMENT extends zio.aws.proton.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.TemplateType =
      software.amazon.awssdk.services.proton.model.TemplateType.ENVIRONMENT
  }
  case object SERVICE extends zio.aws.proton.model.TemplateType {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.TemplateType =
      software.amazon.awssdk.services.proton.model.TemplateType.SERVICE
  }
}
