package zio.aws.proton.model
import scala.jdk.CollectionConverters.*
sealed trait TemplateVersionStatus {
  def unwrap: software.amazon.awssdk.services.proton.model.TemplateVersionStatus
}
object TemplateVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.proton.model.TemplateVersionStatus
  ): zio.aws.proton.model.TemplateVersionStatus = value match {
    case software.amazon.awssdk.services.proton.model.TemplateVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.proton.model.TemplateVersionStatus.REGISTRATION_IN_PROGRESS =>
      val r = REGISTRATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.proton.model.TemplateVersionStatus.REGISTRATION_FAILED =>
      val r = REGISTRATION_FAILED
      r
    case software.amazon.awssdk.services.proton.model.TemplateVersionStatus.DRAFT =>
      val r = DRAFT
      r
    case software.amazon.awssdk.services.proton.model.TemplateVersionStatus.PUBLISHED =>
      val r = PUBLISHED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.proton.model.TemplateVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.TemplateVersionStatus =
      software.amazon.awssdk.services.proton.model.TemplateVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object REGISTRATION_IN_PROGRESS
      extends zio.aws.proton.model.TemplateVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.TemplateVersionStatus =
      software.amazon.awssdk.services.proton.model.TemplateVersionStatus.REGISTRATION_IN_PROGRESS
  }
  case object REGISTRATION_FAILED
      extends zio.aws.proton.model.TemplateVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.TemplateVersionStatus =
      software.amazon.awssdk.services.proton.model.TemplateVersionStatus.REGISTRATION_FAILED
  }
  case object DRAFT extends zio.aws.proton.model.TemplateVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.TemplateVersionStatus =
      software.amazon.awssdk.services.proton.model.TemplateVersionStatus.DRAFT
  }
  case object PUBLISHED extends zio.aws.proton.model.TemplateVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.proton.model.TemplateVersionStatus =
      software.amazon.awssdk.services.proton.model.TemplateVersionStatus.PUBLISHED
  }
}
