package zio.aws.proton.model
import zio.aws.proton.model.primitives.RoleArnOrEmptyString
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAccountSettingsRequest(
    deletePipelineProvisioningRepository: Optional[Boolean] = Optional.Absent,
    pipelineCodebuildRoleArn: Optional[RoleArnOrEmptyString] = Optional.Absent,
    pipelineProvisioningRepository: Optional[
      zio.aws.proton.model.RepositoryBranchInput
    ] = Optional.Absent,
    pipelineServiceRoleArn: Optional[RoleArnOrEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest = {
    import UpdateAccountSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest
      .builder()
      .optionallyWith(
        deletePipelineProvisioningRepository.map(value =>
          value: java.lang.Boolean
        )
      )(_.deletePipelineProvisioningRepository)
      .optionallyWith(
        pipelineCodebuildRoleArn.map(value =>
          RoleArnOrEmptyString.unwrap(value): java.lang.String
        )
      )(_.pipelineCodebuildRoleArn)
      .optionallyWith(
        pipelineProvisioningRepository.map(value => value.buildAwsValue())
      )(_.pipelineProvisioningRepository)
      .optionallyWith(
        pipelineServiceRoleArn.map(value =>
          RoleArnOrEmptyString.unwrap(value): java.lang.String
        )
      )(_.pipelineServiceRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.proton.model.UpdateAccountSettingsRequest.ReadOnly =
    zio.aws.proton.model.UpdateAccountSettingsRequest.wrap(buildAwsValue())
}
object UpdateAccountSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.proton.model.UpdateAccountSettingsRequest =
      zio.aws.proton.model.UpdateAccountSettingsRequest(
        deletePipelineProvisioningRepository.map(value => value),
        pipelineCodebuildRoleArn.map(value => value),
        pipelineProvisioningRepository.map(value => value.asEditable),
        pipelineServiceRoleArn.map(value => value)
      )
    def deletePipelineProvisioningRepository: Optional[Boolean]
    def pipelineCodebuildRoleArn: Optional[RoleArnOrEmptyString]
    def pipelineProvisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranchInput.ReadOnly]
    def pipelineServiceRoleArn: Optional[RoleArnOrEmptyString]
    def getDeletePipelineProvisioningRepository: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "deletePipelineProvisioningRepository",
        deletePipelineProvisioningRepository
      )
    def getPipelineCodebuildRoleArn: ZIO[Any, AwsError, RoleArnOrEmptyString] =
      AwsError.unwrapOptionField(
        "pipelineCodebuildRoleArn",
        pipelineCodebuildRoleArn
      )
    def getPipelineProvisioningRepository: ZIO[
      Any,
      AwsError,
      zio.aws.proton.model.RepositoryBranchInput.ReadOnly
    ] = AwsError.unwrapOptionField(
      "pipelineProvisioningRepository",
      pipelineProvisioningRepository
    )
    def getPipelineServiceRoleArn: ZIO[Any, AwsError, RoleArnOrEmptyString] =
      AwsError.unwrapOptionField(
        "pipelineServiceRoleArn",
        pipelineServiceRoleArn
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest
  ) extends zio.aws.proton.model.UpdateAccountSettingsRequest.ReadOnly {
    override val deletePipelineProvisioningRepository: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deletePipelineProvisioningRepository())
        .map(value => value: Boolean)
    override val pipelineCodebuildRoleArn: Optional[RoleArnOrEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineCodebuildRoleArn())
        .map(value =>
          zio.aws.proton.model.primitives.RoleArnOrEmptyString(value)
        )
    override val pipelineProvisioningRepository
        : Optional[zio.aws.proton.model.RepositoryBranchInput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineProvisioningRepository())
        .map(value => zio.aws.proton.model.RepositoryBranchInput.wrap(value))
    override val pipelineServiceRoleArn: Optional[RoleArnOrEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pipelineServiceRoleArn())
        .map(value =>
          zio.aws.proton.model.primitives.RoleArnOrEmptyString(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.proton.model.UpdateAccountSettingsRequest
  ): zio.aws.proton.model.UpdateAccountSettingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
